Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/quest_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = -9.03, y = -20.31, z = 5, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["kill_them_all"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_kill_them_all", 
	type = "quest", 
}

Triggers["post_man"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_post_man", 
	type = "quest", 
}

trigger_functions =
{
tf_kill_them_all = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		changeLocalRelations(ENEMY, PIRATS)
		changeLocalRelations(ENEMY, MARAUDERS)
		changeLocalRelations(ALLY, PIRATS, MARAUDERS)
	end
end,
tf_post_man = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if (getGVAR("spawn_post_op") == _YES) then
			if (healthOK("post_man")) then
				local cm = getClosestMerc("post_man", CUR_MISSION.Mercs)
				
				if (service.person2person_distance("post_man", cm) < 10) then
					trigger.active = false
					startDlg("Post", "post_man", cm)
				end
			else
				trigger.active = false
			end
		end
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- quest watcher trigger
--
tf_quest_watcher = CommonTriggers.quest_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
